/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.events.StructurePlacementClient;
import questsadditions.tasks.TasksRegistry;

public class StructureTask
extends Task {
    public String name = "";
    public boolean hasCustomPicture;
    public boolean layer = true;

    public StructureTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.STRUCTURE;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("name", this.name);
        nbt.m_128379_("hasCustomPicture", this.hasCustomPicture);
        nbt.m_128379_("layer", this.layer);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.name = nbt.m_128461_("name");
        this.hasCustomPicture = nbt.m_128471_("hasCustomPicture");
        this.layer = nbt.m_128471_("layer");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.name, Short.MAX_VALUE);
        buffer.writeBoolean(this.hasCustomPicture);
        buffer.writeBoolean(this.layer);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.name = buffer.m_130136_(Short.MAX_VALUE);
        this.hasCustomPicture = buffer.readBoolean();
        this.layer = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("name", this.name, v -> {
            this.name = v;
        }, "");
        config.addBool("hasCustomPicture", this.hasCustomPicture, v -> {
            this.hasCustomPicture = v;
        }, false);
        config.addBool("layer", this.layer, v -> {
            this.layer = v;
        }, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BaseComponent getAltTitle() {
        return new TranslatableComponent("questsadditions.task.structure.title", new Object[]{this.name});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        list.blankLine();
        if (StructurePlacementClient.isLocked()) {
            list.add((Component)new TranslatableComponent("ftbquests.task.click_to_submit").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else {
            list.add((Component)new TranslatableComponent("questsadditions.structure_task.show").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.hasCustomPicture) {
            return Icon.getIcon((String)("questsadditions:textures/structure_icons/" + this.name + ".png"));
        }
        return super.getAltIcon();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        if (!ClientQuestFile.INSTANCE.self.isCompleted((QuestObject)this)) {
            StructurePlacementClient.toggleShowStructure(this.name, this.id, this.layer);
        }
    }
}

